/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.listener;

import java.util.ArrayList;
import java.util.Map;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Duo;

public interface UpdateListener<C> {
    default public void beforeUpdate(Iterable<? extends Duo<C, C>> payloads, boolean allColumnsStatement) {
    }

    default public void afterUpdate(Iterable<? extends Duo<C, C>> entities, boolean allColumnsStatement) {
    }

    default public void onUpdateError(Iterable<? extends C> entities, RuntimeException runtimeException) {
    }

    public static <C, T extends Table<T>> Iterable<UpdatePayload<C, T>> computePayloads(Iterable<? extends Duo<C, C>> entities, boolean allColumns, Mapping<C, T> mapping) {
        return UpdateListener.computePayloads(entities, allColumns, mapping::getUpdateValues);
    }

    public static <C, T extends Table<T>> Iterable<UpdatePayload<C, T>> computePayloads(Iterable<? extends Duo<C, C>> entities, boolean allColumns, UpdateValuesProvider<C, T> mappingStrategy) {
        ArrayList<UpdatePayload<C, T>> result = new ArrayList<UpdatePayload<C, T>>();
        for (Duo<C, C> next : entities) {
            Object modified = next.getLeft();
            Object unmodified = next.getRight();
            Map<Mapping.UpwhereColumn<T>, ?> updateValues = mappingStrategy.getUpdateValues(modified, unmodified, allColumns);
            UpdatePayload<C, T> payload = new UpdatePayload<C, T>(next, updateValues);
            result.add(payload);
        }
        return result;
    }

    public static interface UpdateValuesProvider<C, T extends Table<T>> {
        public Map<Mapping.UpwhereColumn<T>, ?> getUpdateValues(C var1, C var2, boolean var3);
    }

    public static class UpdatePayload<C, T extends Table<T>> {
        private final Duo<? extends C, ? extends C> entities;
        private final Map<Mapping.UpwhereColumn<T>, ?> values;

        public UpdatePayload(Duo<? extends C, ? extends C> entities, Map<Mapping.UpwhereColumn<T>, ?> values) {
            this.entities = entities;
            this.values = values;
        }

        public Duo<C, C> getEntities() {
            return this.entities;
        }

        public Map<Mapping.UpwhereColumn<T>, ?> getValues() {
            return this.values;
        }
    }
}

